/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.text.rules;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.MultiLineRule;

public class DoubleQuotedStringRule
extends MultiLineRule {
    public DoubleQuotedStringRule(IToken token) {
        super("\"", "\"", token, '\\', true);
    }

    protected boolean endSequenceDetected(ICharacterScanner scanner) {
        int c;
        int openBrackets = 0;
        while ((c = scanner.read()) != -1) {
            if (c == this.fEscapeCharacter) {
                scanner.read();
                continue;
            }
            if (openBrackets > 0) {
                if (c == 123) {
                    ++openBrackets;
                    continue;
                }
                if (c != 125) continue;
                --openBrackets;
                continue;
            }
            if (c == 123) {
                c = scanner.read();
                if (c == 36) {
                    openBrackets = 1;
                    continue;
                }
                if (c == -1) continue;
                scanner.unread();
                continue;
            }
            if (c == this.fEndSequence[0] && this.sequenceDetected(scanner, this.fEndSequence, this.fBreaksOnEOF)) break;
        }
        return true;
    }
}

